package ru.yandex.autotests.direct.db.steps.base;

import ru.yandex.autotests.direct.db.configuration.DirectConfiguration;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.qatools.properties.PropertyLoader;

import java.net.URI;
import java.net.URISyntaxException;

import static ru.yandex.autotests.direct.db.ConfigUtils.getDirectConfiguration;

/*
* todo javadoc
*/
public class DBStepsContext {
    private DirectConfiguration config;

    private int currentPpcShard = 0;

    private DirectDBProperties props = new DirectDBProperties();
    private DirectTestRunProperties directTestRunProperties = DirectTestRunProperties.getInstance();

    public DBStepsContext() {
        PropertyLoader.populate(props);
        PropertyLoader.populate(directTestRunProperties);
    }

    public void initConfig(String configUrl) {
        try {
            config = getDirectConfiguration(new URI(configUrl));
        } catch (URISyntaxException e) {
            throw new DirectDbStepsException("Неверный url конфигурации баз", e);
        } catch (Exception e) {
            throw new DirectDbStepsException("Ошибка получения конфигурации базы по адресу: " + configUrl, e);
        }
    }

    public String getDirectIntapiJavaHost() { return directTestRunProperties.getDirectIntapiJavaHost(); }

    public String getDirectIntapiJavaHost(String stage) { return directTestRunProperties.getDirectIntapiJavaHost(stage); }

    public String getUser() {
        return props.getUser();
    }

    public String getPassword() {
        return props.getPassword();
    }

    public DBStepsContext withUser(String user) {
        this.props.withUser(user);
        return this;
    }

    public DBStepsContext withPassword(String password) {
        this.props.withPassword(password);
        return this;
    }

    public DirectConfiguration getConfig() {
        return config;
    }

    public void setConfig(DirectConfiguration config) {
        this.config = config;
    }

    public int getCurrentPpcShard() {
        if(currentPpcShard == 0) {
            throw new DirectDbStepsException("Необходимо задать shard для базы ppc в DirectJooqDbSteps");
        }
        return currentPpcShard;
    }

    public DBStepsContext withCurrentPpcShard(int currentPpcShard) {
        this.currentPpcShard = currentPpcShard;
        return this;
    }
}
