package ru.yandex.autotests.direct.db.steps.base;

import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.secrets.SecretWithKey;
import ru.yandex.qatools.secrets.SecretsLoader;

/*
 * Данные, необходимые для подключения к тестовой базе.
 * Логин берем из конфига, пароль достаем из Секретницы:
 * https://yav.yandex-team.ru/secret/sec-01edxs5gad1xq685sz2csg3c39
 */
@Resource.Classpath("direct.db.properties")
public class DirectDBProperties {
    private static final String SECRET_ID = "sec-01edxs5gad1xq685sz2csg3c39";
    private static final String KEY_SECRET = "direct.test.mysql_autotester_password";

    @SecretWithKey(secret = SECRET_ID, key = KEY_SECRET)
    private String password;

    @Property("direct.db.username")
    private String user;

    public DirectDBProperties() {
        SecretsLoader.populate(this);
    }

    public String getUser() {
        return user;
    }

    public DirectDBProperties withUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public DirectDBProperties withPassword(String password) {
        this.password = password;
        return this;
    }
}
