package ru.yandex.autotests.direct.db;

import java.net.URI;
import java.util.HashMap;

import org.jooq.util.GenerationTool;
import org.jooq.util.jaxb.Configuration;
import org.jooq.util.jaxb.Database;
import org.jooq.util.jaxb.ForcedType;
import org.jooq.util.jaxb.Generate;
import org.jooq.util.jaxb.Generator;
import org.jooq.util.jaxb.Jdbc;
import org.jooq.util.jaxb.Target;

import ru.yandex.autotests.direct.db.configuration.DBInfo;
import ru.yandex.autotests.direct.db.configuration.DirectConfiguration;

import static ru.yandex.autotests.direct.db.ConfigUtils.getDirectConfiguration;

/*
* todo javadoc
*/
public class JooqModelsGenerator {

    public static void main(String[] args) throws Exception {

        if (args.length != 1 || "".equals(args[0])) {
            throw new IllegalArgumentException("You should pass DirectConfiguration url as an argument");
        }

        URI configUrl = new URI(args[0]);

        HashMap<String, String> bases = new HashMap<>();
        bases.put("ppc:1", "ppc");
        bases.put("monitor", "monitor");
        bases.put("ppcdict", "ppcdict");

        DirectConfiguration conf = getDirectConfiguration(configUrl);

        HashMap<String, DBInfo> databases = new HashMap<>();
        for (String key : conf.getConfigs().keySet()) {
            if (bases.containsKey(key)) {
                databases.put(bases.get(key), conf.getConfigs().get(key));
            }
        }

        databases.keySet().parallelStream()
                .forEach(key -> {
                    Configuration jooqConf = getJooqConf();
                    jooqConf.getGenerator().getTarget().withPackageName("ru.yandex.autotests.direct.db.models.jooq." + key);
                    jooqConf.getGenerator().getDatabase().withInputSchema(key);
                    jooqConf.getJdbc().withUrl("jdbc:mysql://" +
                            databases.get(key).getHost() + ":" +
                            databases.get(key).getPort() + "/" +
                            key);
                    try {
//                        System.out.println(new GsonBuilder().setPrettyPrinting().create().toJson(jooqConf));
                        GenerationTool.generate(jooqConf);
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
    }

    private static Configuration getJooqConf() {
        Jdbc jdbc = new Jdbc();
        jdbc.withDriver("com.mysql.jdbc.Driver")
                .withUser("reader")
                .withPassword("ztGUlpDM");

        Database database = new Database()
                .withName("org.jooq.util.mysql.MySQLDatabase")
                .withIncludes(".*")
                .withExcludes("")
                .withUnsignedTypes(true)
                .withForcedTypes(
                        //Поля у которых в базе тип big unsigned, но в тестах уже используются как Long.
                        // Поэтому оставляем для них тип Long, т.к. много переделывать
                        new ForcedType().withExpression("ppc.additions_item_callouts.hash").withName("DECIMAL_INTEGER"),
                        new ForcedType().withExpression("ppc.wallet_payment_transactions.id").withName("BIGINT"),
                        new ForcedType().withExpression("ppc.bids.id").withName("BIGINT"),
                        new ForcedType().withExpression("ppc.mod_object_version.obj_id").withName("BIGINT"),
                        new ForcedType().withExpression("ppc.mod_reasons.id").withName("BIGINT"),
                        new ForcedType().withExpression("ppcdict.api_domain_stat.sum_approx").withName("BIGINT"),
                        new ForcedType().withExpression("ppcdict.shard_order_id.OrderID").withName("BIGINT"),
                        new ForcedType().withExpression("bid").withName("BIGINT"),
                        new ForcedType().withExpression("total_balance_tid").withName("BIGINT"),
                        new ForcedType().withExpression("payer_uid").withName("BIGINT"),
                        new ForcedType().withExpression("uid").withName("BIGINT"),
                        new ForcedType().withExpression("mobile_content_id").withName("BIGINT"),
                        new ForcedType().withExpression("creative_id").withName("BIGINT"),
                        new ForcedType().withExpression("feed_id").withName("BIGINT"),
                        new ForcedType().withExpression("experiment_id").withName("BIGINT"),
                        new ForcedType().withExpression("perf_filter_id").withName("BIGINT"),
                        new ForcedType().withExpression("ppc.campaigns.strategy_data")
                                .withUserType("com.google.gson.JsonElement")
                                .withBinding("ru.yandex.autotests.direct.db.MysqlJSONGsonBinding"),

                        new ForcedType().withTypes("int").withName("BIGINT"),
                        new ForcedType().withTypes("intunsigned").withName("BIGINT"),
                        new ForcedType().withTypes("tinyint").withName("INT"),
                        new ForcedType().withTypes("tinyintunsigned").withName("INT"),
                        new ForcedType().withTypes("smallintunsigned").withName("SMALLINT"),
                        new ForcedType().withTypes("bigintunsigned").withName("DECIMAL_INTEGER"),
                        new ForcedType().withTypes("json").withName("CLOB")
                );

        Target target = new Target().withDirectory("db-models/target/generated-sources/jooq");


        Generator generator = new Generator()
                .withName(org.jooq.util.JavaGenerator.class.getName())
                .withDatabase(database)
                .withTarget(target)
                .withGenerate(new Generate().withFluentSetters(true));


        Configuration configuration = new Configuration();
        configuration.setJdbc(jdbc);
        configuration.setGenerator(generator);

        return configuration;
    }


}
