package ru.yandex.autotests.direct.handles;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Main {
    private static final int PORT = 9002;
    private static final String HOST = "127.0.0.1";
    private static final String WEB_XML =
            "META-INF/webapp/WEB-INF/web.xml";

    public static void main(String[] args) throws Exception {
        Server server;
        server = new Server(createThreadPool());
        ServerConnector connector = new ServerConnector(server);
        connector.setHost(HOST);
        connector.setPort(PORT);
        server.setConnectors(new Connector[] { connector });
        server.setHandler(createHandlers());
        server.setStopAtShutdown(true);
        server.start();
    }

    private static ThreadPool createThreadPool()
    {
        // TODO: You should configure these appropriately
        // for your environment - this is an example only
        QueuedThreadPool _threadPool = new QueuedThreadPool();
        _threadPool.setMinThreads(10);
        _threadPool.setMaxThreads(200);
        return _threadPool;
    }

    private static HandlerCollection createHandlers()
    {
        WebAppContext _ctx = new WebAppContext();
        _ctx.setContextPath("/");
        _ctx.setWar(getShadedWarUrl());
        List<Handler> _handlers = new ArrayList<Handler>();
        _handlers.add(_ctx);

        HandlerList _contexts = new HandlerList();
        _contexts.setHandlers(_handlers.toArray(new Handler[0]));

        RequestLogHandler _log = new RequestLogHandler();

        HandlerCollection _result = new HandlerCollection();
        _result.setHandlers(new Handler[] {_contexts, _log});

        return _result;
    }

    private static String getShadedWarUrl()
    {
        String _urlStr = getResource(WEB_XML).toString();
        // Strip off "WEB-INF/web.xml"
        return _urlStr.substring(0, _urlStr.length() - 15);
    }

    private static URL getResource(String aResource)
    {
        return Thread.currentThread().
                getContextClassLoader().getResource(aResource);
    }
}
