package ru.yandex.autotests.direct.handles.api;

import org.hibernate.internal.util.SerializationHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.DBConnectionService;
import ru.yandex.autotests.direct.handles.db.beans.DBElementBean;
import ru.yandex.autotests.direct.handles.db.beans.DbSearchBean;
import ru.yandex.autotests.direct.handles.db.beans.DbSearchByPrimaryKeyBean;
import ru.yandex.autotests.direct.handles.db.beans.DbSearchResultBean;
import ru.yandex.autotests.direct.handles.db.beans.DbUpdateBean;
import ru.yandex.autotests.direct.handles.db.beans.DbUpdateResultBean;
import ru.yandex.autotests.direct.handles.utils.DirectHandlesException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.io.Serializable;


/**
 * Created by omaz on 17.01.14.
 */
@Component
@Path("/dbconnection")
public class DBConnectionRestService {
    @Autowired
    private DBConnectionService getDBConnectionService;

    private DbSearchResultBean exceptionAsDbSearchResultBean(Exception e) {
        e.printStackTrace();
        DbSearchResultBean resultBean = new DbSearchResultBean();
        DBElementBean dbElementBean = new DBElementBean();
        dbElementBean.setClassName(e.getClass().getName());
        dbElementBean.setError(SerializationHelper.serialize(e));
        resultBean.setResult(dbElementBean);
        return resultBean;
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/find-one/")
    public DbSearchResultBean findOne(DbSearchBean dbSearchBean){
        try {
            return getDBConnectionService.findOne(dbSearchBean);
        } catch (Exception e) {
            return exceptionAsDbSearchResultBean(e);
        }
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/find-all/")
    public DbSearchResultBean findAll(DbSearchBean dbSearchBean){
        try {
            return getDBConnectionService.findAll(dbSearchBean);
        } catch (Exception e) {
            return exceptionAsDbSearchResultBean(e);
        }
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/find-by-primary-key/")
    public DbSearchResultBean findByPrimaryKey(DbSearchByPrimaryKeyBean dbSearchBean){
        try {
            return getDBConnectionService.findByPrimaryKey(dbSearchBean);
        } catch (Exception e) {
            return exceptionAsDbSearchResultBean(e);
        }
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/find-with-projection/")
    public DbSearchResultBean findWithProjection(DbSearchBean dbSearchBean){
        try {
            return getDBConnectionService.findWithProjection(dbSearchBean);
        } catch (Exception e) {
            return exceptionAsDbSearchResultBean(e);
        }
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/update/")
    public DbUpdateResultBean update(DbUpdateBean dbUpdateBean){
        try {
            getDBConnectionService.update(dbUpdateBean);
        } catch (Exception e) {
            throw new DirectHandlesException(e);
        }
        DbUpdateResultBean updateResultBean = new DbUpdateResultBean();
        updateResultBean.setStatus("OK");
        return updateResultBean;
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/save/")
    public DbUpdateResultBean save(DbUpdateBean dbUpdateBean){
        Serializable result = null;
        try {
            result = getDBConnectionService.save(dbUpdateBean);
        } catch (Exception e) {
            throw new DirectHandlesException(e);
        }
        DbUpdateResultBean updateResultBean = new DbUpdateResultBean();
        updateResultBean.setStatus("OK");
        if(result != null) {
            updateResultBean.setResult(JsonUtils.toString(result));
        }
        return updateResultBean;
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/delete/")
    public DbUpdateResultBean delete(DbUpdateBean dbUpdateBean){
        try {
            getDBConnectionService.delete(dbUpdateBean);
        } catch (Exception e) {
            throw new DirectHandlesException(e);
        }
        DbUpdateResultBean updateResultBean = new DbUpdateResultBean();
        updateResultBean.setStatus("OK");
        return updateResultBean;
    }
}
