package ru.yandex.autotests.direct.handles.utils;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * User: buhter
 * Date: 28.11.13
 * Time: 15:55
 */
public class DirectHandlesException extends WebApplicationException {
    private static final long serialVersionUID = 1L;
    public DirectHandlesException() {
        super(Response.status(Response.Status.INTERNAL_SERVER_ERROR)
                .build());
    }

    public DirectHandlesException(String message) {
        super(Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(message)
                .type(MediaType.TEXT_PLAIN).header("Content-Type", "text/plain; charset=utf-8").build());
    }

    public DirectHandlesException(String message, Throwable e) {
        super(e, Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(message)
                .type(MediaType.TEXT_PLAIN).header("Content-Type", "text/plain; charset=utf-8").build());
    }

    public DirectHandlesException(Throwable e) {
        super(e, Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage())
                .type(MediaType.TEXT_PLAIN).header("Content-Type", "text/plain; charset=utf-8").build());
    }
}
