function sendPostRequest(serviceUrl, JSONData, callBack) {
    $("#spinner").show();
    $("#results").html("");
    $("#alert").hide();
    $("#error").html("");
    $.ajax({
        url: directHandlesUrl +"/" + serviceUrl,
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json;charset=UTF-8'
        },
        type: "POST",
        data: JSON.stringify(JSONData),
        dataType: "json",
        wait: true,
        beforeSend: function(x) {
            if (x && x.overrideMimeType) {
                x.overrideMimeType("application/json;charset=UTF-8");
            }
        },
        success: function(result){
            callBack(result);
            $("#spinner").hide();
            $(".results").show();
        },
        error: function(xhr, ajaxOptions, e) {
            if(xhr.status == 200){
                callBack(xhr.responseText);
                $("#spinner").hide();
                return;
            }
            $("#error").html("Возникла ошибка при запросе: Статус ответа: " + xhr.status
                + " Текст ошибки: " + xhr.responseText);
            $("#spinner").hide();
            $("#alert").show();
        }
    });
};

/**
 *      послать GET-запрос
 *     @param serviceUrl - url GET-запроса
 *     @param callBack - функция, вызываемая после успешного выполнения запроса, в качестве аргумента ей передается
 *      результат выполнения запроса
 *     @param showResults (не обязательный) - передавать ли результаты функции callBack в блок .results, по умолчанию false
 *     @param bootstrapSortable (не обязательный) - выполнять ли метод bootstrapSortable при успешном выполнении запроса,
 *      по умолчанию false
 */
function sendGetRequestByUrl(serviceUrl, callBack, showResults, bootstrapSortable) {
    $("#spinner").show();
    $("#results").html("");
    $("#alert").hide();
    $("#error").html("");
    $.ajax({
        url: serviceUrl,
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json;charset=UTF-8'
        },
        type: "GET",
        wait: true,
        beforeSend: function(x) {
            if (x && x.overrideMimeType) {
                x.overrideMimeType("application/json;charset=UTF-8");
            }
        },
        success: function(result){
            var callBackResult = callBack(result);
            $("#spinner").hide();
            if ((showResults == null || showResults)) {
                $("#results").html(callBackResult);
            }
            $("#results").show();
            if (bootstrapSortable == null || bootstrapSortable) {
                $.bootstrapSortable();
            }
        },
        error: function(xhr, ajaxOptions, e) {
            $("#error").html("Возникла ошибка при запросе: Статус ответа: " + xhr.status
                + " Текст ошибки: " + xhr.responseText);
            $("#spinner").hide();
            $("#alert").show();
        }
    });
};

function sendGetRequest(serviceUrl, callBack, showResults, bootstrapSortable) {
    sendGetRequestByUrl(directHandlesUrl +"/" + serviceUrl, callBack, showResults, bootstrapSortable);
};

/**
 *      послать GET-запрос в формате TEXT_PLAIN
 *     @param serviceUrl - url GET-запроса
 *     @param callBack - функция, вызываемая после успешного выполнения запроса, в качестве аргумента ей передается
 *      результат выполнения запроса
 *     @param spinner (не обязательный) - показывать ли статус загрузки во время выполнения запроса, по умолчанию true
 *     @param results (не обязательный) - показывать ли блок с результатами #results при успешном выолнении запроса,
 *      по умолчанию true
 *
*/
function sendGetRequestPlain(serviceUrl, callBack, spinner, results) {
    if (spinner == null || spinner) {
        $("#spinner").show();
    }
    if (results == null || results) {
        $("#results").html("");
    }
    $("#alert").hide();
    $("#error").html("");
    $.ajax({
        url: directHandlesUrl +"/" + serviceUrl,
        type: "GET",
        wait: true,
        success: function(result){
            callBack(result);
            if (spinner == null || spinner) {
                $("#spinner").hide();
            }
            if (results == null || results) {
                $(".results").show();
            }
        },
        error: function(xhr, ajaxOptions, e) {
            $("#error").html("Возникла ошибка при запросе: Статус ответа: " + xhr.status
                + " Текст ошибки: " + xhr.responseText);
            if (spinner == null || spinner) {
                $("#spinner").hide();
            }
            $("#alert").show();
        }
    });
};

function sendPutRequestByUrl(serviceUrl, JSONData, callBack) {
    $("#spinner").show();
    $("#results").html("");
    $("#alert").hide();
    $("#error").html("");
    $.ajax({
        url: serviceUrl,
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json;charset=UTF-8'
        },
        type: "PUT",
        data: JSON.stringify(JSONData),
        dataType: "json",
        wait: true,
        beforeSend: function(x) {
            if (x && x.overrideMimeType) {
                x.overrideMimeType("application/json;charset=UTF-8");
            }
        },
        success: function(result){
            callBack(result);
            $("#spinner").hide();
        },
        error: function(xhr, ajaxOptions, e) {
            $("#error").html("Возникла ошибка при запросе: Статус ответа: " + xhr.status
                + " Текст ошибки: " + xhr.responseText);
            $("#spinner").hide();
            $("#alert").show();
        }
    });
};

function sendPutRequest(serviceUrl, JSONData, callBack) {
    sendPutRequestByUrl(directHandlesUrl +"/" + serviceUrl, JSONData, callBack);
};

//Generate table by object list
function generateTable(data, headers){
    var s = "<div class='table-responsive'>" +
        "<table class='table table-hover table-condensed table-bordered table-striped'>" +
        "<thead>"
    $.each(headers, function() {
        s += "<th>"+ this +"</th>";
    });
    s += "</thead>";
    $.each(data, function() {
        var tbl_row = "";
        $.each(this, function(k , v) {
            tbl_row += "<td>"+ v +"</td>";
        })
        s += "<tr>"+tbl_row+"</tr>";
    });
    s += "</table></div>";
    return s;
};

//Generate table by simple type list
function generateTableSimple(data, headers){
    var s = "<div class='table-responsive'>" +
        "<table class='table table-hover table-condensed table-bordered table-striped'>" +
        "<thead>";
    $.each(headers, function() {
        s += "<th>"+ this +"</th>";
    });
    s += "</thead>";
    $.each(data, function() {
        s += "<tr><td>"+this+"</td></tr>";
    });
    s += "</table></div>";
    return s;
};

function parseGetParams() {
    var $_GET = {};
    var __GET = window.location.search.substring(1).split("&");
    for(var i = 0; i < __GET.length; i++) {
        var getVar = __GET[i].split("=");
        $_GET[getVar[0]] = typeof(getVar[1])=="undefined" ? "" : getVar[1];
    }
    return $_GET;
};
