#!/bin/bash
JAVA_ARGS="-Djava.net.preferIPv6Addresses=true -Dfile.encoding=UTF-8 -Xms${APP_XMS:-2G} -Xmx${APP_XMX:-2G} -DLOG_LEVEL=${LOG_LEVEL:-ERROR}"

if [ $DEBUG_PORT ]
then
JAVA_ARGS="$JAVA_ARGS -agentlib:jdwp=transport=dt_socket,server=y,address=$DEBUG_PORT,suspend=${SUSPEND:-n} "
fi

exec env VAULT_TOKEN=$YAV_TOKEN /usr/local/java8/bin/java $JAVA_ARGS -Dport=${QLOUD_HTTP_PORT} -Dwar=/usr/share/direct-handles-rest/direct-handles-rest.war -DcontextPath=/ -Drestheart.http.host=${MONGO_HTTP_HOST} -jar /usr/share/jetty/jetty-starter.jar
