package ru.yandex.autotests.direct.handles.aquahelper;

import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.handles.aquahelper.utils.AccountsMongoHelper;
import ru.yandex.autotests.direct.handles.aquahelper.utils.AquaHelperTestEnvironment;
import ru.yandex.autotests.direct.web.steps.PassportApiSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

/**
 * User: buhter
 * Date: 04.09.13
 * Time: 14:37
 */
@Aqua.Test
@Features("Создание новых аккаунтов")
@Stories("Базовое создание аккаунтов")
@Title("Создаем аккаунты с параметрами по умолчанию")
public class BaseCreateAccounts {

    final PassportApiSteps passportApiSteps = PassportApiSteps.getInstance();

    @Test
    public void test(){
        User account;
        for(int i = 0; i < AquaHelperTestEnvironment.getAquaHelperProperties().getAccountsAmount(); i ++){
            account = passportApiSteps.createNewUser();
            account.setSandboxToken(AquaHelperTestEnvironment.getAquaHelperProperties().getSessionUUID());
            new AccountsMongoHelper().addMongoBean(account);
        }
    }
}
