package ru.yandex.autotests.direct.handles.aquahelper;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.handles.aquahelper.utils.AccountsMongoHelper;
import ru.yandex.autotests.direct.handles.aquahelper.utils.AquaHelperTestEnvironment;
import ru.yandex.autotests.direct.web.steps.PassportApiSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.passport.api.tools.registration.RegUser;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

/**
 * User: buhter
 * Date: 04.09.13
 * Time: 14:37
 */
@Aqua.Test
@Features("Создание новых аккаунтов")
@Stories("Создание новых аккаунтов с указанием логина и пароля")
@Title("Создаем аккаунты с указанием логина и пароля")
public class CreateSpecifiedAccounts {

    final PassportApiSteps passportApiSteps = PassportApiSteps.getInstance();
    AccountsMongoHelper accountsMongoHelper = new AccountsMongoHelper();
    @Test
    public void createUsers() {
        String loginPrefix = AquaHelperTestEnvironment.getAquaHelperProperties().getLoginPrefix();
        String pass = AquaHelperTestEnvironment.getAquaHelperProperties().getPassword();
        if((AquaHelperTestEnvironment.getAquaHelperProperties().getLoginPostfixStart() == 0)
                && (AquaHelperTestEnvironment.getAquaHelperProperties().getLoginPostfixEnd() == 0)){
            accountsMongoHelper.addMongoBean(createAccount(loginPrefix, pass));
        } else{
            for(int i = AquaHelperTestEnvironment.getAquaHelperProperties().getLoginPostfixStart()
                        ; i <= AquaHelperTestEnvironment.getAquaHelperProperties().getLoginPostfixEnd()
                    ; i++) {
                String login = loginPrefix + String.valueOf(i);
                User user = createAccount(login, pass);
                accountsMongoHelper.addMongoBean(user);
            }
        }
    }

    private User createAccount(String login, String pass){
        try {
            System.setProperty("base.scheme", "prod");
            User account = passportApiSteps.createNewUser(login, pass);
            account.setLogin(login);
            account.setPassword(pass);
            account.setSandboxToken(AquaHelperTestEnvironment.getAquaHelperProperties().getSessionUUID());
            return account;
        } catch (Exception e) {
            User account = new User();
            account.setLogin(login);
            account.setPassword("Exception: " + e.getMessage());
            account.setSandboxToken(AquaHelperTestEnvironment.getAquaHelperProperties().getSessionUUID());
            return account;
        }
    }
}
