package ru.yandex.autotests.direct.handles.aquahelper.utils;


import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;

public class AccountsMongoHelper extends BaseMongoHelper<User> {
    private static final String COLLECTION = "TestUsers";
    private static final String QUERY_TEMPLATE = "{login:\"%s\"}";
    public AccountsMongoHelper() {
        super(User.class);
    }

    @Override
    public String getUniqueFilter(User user) {
        return String.format(QUERY_TEMPLATE, user.getLogin());
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }

    @Override
    public String getDb() {
        return MongoDatabases.BEAN_TEMAPLATES.getDbName();
    }
}
