package ru.yandex.autotests.direct.handles.aquahelper.utils;

import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;

import java.lang.String;

/**
 * User: buhter
 * Date: 05.09.13
 * Time: 12:14
 */
@Resource.Classpath("aquaHelper.properties")
public class AquaHelperProperties {
    public AquaHelperProperties() {
        PropertyLoader.populate(this);
    }

    public String getSessionUUID() {
        return sessionUUID;
    }

    public int getAccountsAmount() {
        return accountsAmount;
    }

    public String getLoginPrefix() {
        return loginPrefix;
    }

    public int getLoginPostfixStart() {
        return loginPostfixStart;
    }

    public int getLoginPostfixEnd() {
        return loginPostfixEnd;
    }

    public String getPassword() {
        return password;
    }

    public String getCountry() {
        return country;
    }

    public String getCurrency() {
        return currency;
    }

    public String getMongoHttpHost() {
        return mongoHttpHost;
    }

    @Property("session.uuid")
    private String sessionUUID;

    @Property("accounts.amount")
    private int accountsAmount;

    @Property("login.prefix")
    private String loginPrefix;

    @Property("login.postfix.start")
    private int loginPostfixStart;

    @Property("login.postfix.end")
    private int loginPostfixEnd;

    @Property("password")
    private String password;

    @Property("country")
    private String country;

    @Property("currency")
    private String currency;

    @Property("mongo.http.host")
    private String mongoHttpHost;
}
