package ru.yandex.autotests.direct.scriptrunner.service.scripts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptParams {

    protected Map<String, Object> params = new HashMap<>();

    public ScriptParams() {}

    public ScriptParams(ScriptParams scriptParams) {
        this.params = new HashMap<>(scriptParams.params);
    }

    public void put(String key, String value) {
        params.put(key, Collections.singletonList(value));
    }

    public void put(String key, List<String> value) {
        params.put(key, value);
    }

    public Object get(String key) {
        return params.get(key);
    }

    public Object remove(String key) {
        return params.remove(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScriptParams that = (ScriptParams) o;

        return params.equals(that.params);

    }

    @Override
    public int hashCode() {
        return params.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        params.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                builder.append(entry.getKey());
                builder.append(" ");
            } else if (value instanceof String) {
                builder.append(entry.getKey());
                builder.append("=").append(value);
                builder.append(" ");
            } else if (value instanceof List) {
                for (Object valueItem : (List) value) {
                    builder.append(entry.getKey());
                    builder.append("=").append(valueItem);
                    builder.append(" ");
                }
            }
        });
        return builder.toString();
    }

    protected void setBoolVariable(String key, Boolean value) {
        if (value) {
            params.put(key, true);
        } else {
            params.remove(key);
        }
    }
}
