package ru.yandex.autotests.direct.scriptrunner.service.scripts;

public class ScriptRunTask {

    private ScriptDBConfig scriptDBConfig;
    private ScriptRunParams scriptRunParams;

    public ScriptRunTask(ScriptDBConfig scriptDBConfig,
                         ScriptRunParams scriptRunParams) {
        if (scriptDBConfig == null) {
            throw new IllegalArgumentException("parameter scriptDBConfig must not be null");
        }
        if (scriptRunParams == null) {
            throw new IllegalArgumentException("parameter scriptRunParams must not be null");
        }
        this.scriptDBConfig = scriptDBConfig;
        this.scriptRunParams = scriptRunParams;
    }

    public ScriptDBConfig getScriptDBConfig() {
        return scriptDBConfig;
    }

    public ScriptRunParams getScriptRunParams() {
        return scriptRunParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ScriptRunTask that = (ScriptRunTask) o;

        return scriptDBConfig.equals(that.scriptDBConfig) && scriptRunParams.equals(that.scriptRunParams);

    }

    @Override
    public int hashCode() {
        int result = scriptDBConfig.hashCode();
        result = 31 * result + scriptRunParams.hashCode();
        return result;
    }
}
