package ru.yandex.autotests.direct.handles.monitorings;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
* Created by buhter on 22.01.14.
*     ppctest-devtest-mysql
         SET GLOBAL auto_increment_increment = 5;
         SET GLOBAL auto_increment_offset = 1;
         ppctest-dev7-mysql
         SET GLOBAL auto_increment_increment = 5;
         SET GLOBAL auto_increment_offset = 2;
         ppctest-ts-mysql
         SET GLOBAL auto_increment_increment = 5;
         SET GLOBAL auto_increment_offset = 3;
         ppctest-ts-mysql
         SET GLOBAL auto_increment_increment = 5;
         SET GLOBAL auto_increment_offset = 4;
         ppctest-load-mysql
         SET GLOBAL auto_increment_increment = 5;
         SET GLOBAL auto_increment_offset = 5;
*/
@Aqua.Test(title = "Проверка инкремента в базах Директа", description = "Проверка инкремента в базах Директа")
@Feature("NotificationMonitorings")
@RunWith(Parameterized.class)
public class DBIncrementTest {
    @Rule
    public BottleMessageRule bottleMessageRule = new BottleMessageRule();

    private final static int INCREMENT = 5;
    private final static List<LinkedTreeMap<String, String>> ENVIRONMENTS = getEnvironmentsList();
    private final static String URL = "http://ppctest-handles.yandex.ru/xmlrpc/list/get";
    private final String userName = "at-direct-c-full";
    private String dbName;
    private int moduleForDb;
    private ApiSteps steps;
    private int firstCampaignId;
    private int secondCampaignId;

    public DBIncrementTest(String dbName, int moduleForDb) {
        this.dbName = dbName;
        this.moduleForDb = moduleForDb;
    }

    @Parameterized.Parameters(name = "{index}:db={0}")
    public static Collection data() {
        Object[][] data = new Object[][] {
                  {"ppctest-ts-mysql", 3}
                , {"ppctest-ts2-mysql",  4}
                , {"ppctest-devtest-mysql", 1}
                , {"ppctest-dev7-mysql", 2}
//                , {"ppctest-load-mysql", 0}
        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaigns() throws IOException {
        String endPoint = getUrlForDBName(dbName);
        steps = new ApiSteps().url(endPoint);
        firstCampaignId = steps.userSteps.createDraftCampaign(userName);
        secondCampaignId = steps.userSteps.createDraftCampaign(userName);
    }

    private String getUrlForDBName(String dbName) {
        for (LinkedTreeMap<String, String> environment : ENVIRONMENTS) {
            if(environment.get("name").equals(dbName)){
                return environment.get("url").replace("/xmlrpc", ":14443");
            }
        }
        return null;
    }

    @Test
    public void checkDbIncrement(){
        assertThat("Неверный инкремент в базе " + dbName, (secondCampaignId - firstCampaignId) % INCREMENT, equalTo(0));
    }

    @Test
    public void checkDbOffset(){
        assertThat("Неверное смещение в базе " + dbName, firstCampaignId % INCREMENT,  equalTo(moduleForDb));
    }

    @After
    public void deleteCampaigns(){
        steps.userSteps.deleteActiveCampaignsQuietly(firstCampaignId, secondCampaignId);
    }

    private static List<LinkedTreeMap<String, String>> getEnvironmentsList() {
        HttpClient httpClient = new DefaultHttpClient();
        HttpGet get = new HttpGet(URL);
        try {
            HttpResponse response = httpClient.execute(get);
            String s = EntityUtils.toString(response.getEntity());
            return (List<LinkedTreeMap<String, String>>)new Gson().fromJson(s, List.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

