package ru.yandex.autotests.direct.handles.monitorings;

import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.balance.lib.environment.Environment;
import ru.yandex.autotests.balance.lib.xmlrpc.UnitTestLib;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by buhter on 22.01.14.
 */
@Aqua.Test(title = "Проверка адресации нотификаций баланса на наш прокси-сервис", description =
        "Проверка адресации нотификаций баланса на наш прокси-сервис")
@Feature("NotificationMonitorings")
public class IsBalanceNotificationSetToProxyTest {
    @Rule
    public BottleMessageRule bottleMessageRule = new BottleMessageRule();

    private static final String PROXY_URL = "http://ppctest-handles.ppc.yandex.ru/xmlrpc/proxy/";

    @Test
    public void testIsBalanceTSNotificationSetToProxy() throws Exception {
        assertThat("Нотификации баланса настроены не на прокси сервис " + PROXY_URL
                , new UnitTestLib(Environment.INTEGRATION).getXmlrpcProxyUrlDirect(), equalTo(PROXY_URL));

    }

    @Test
    public void testIsBalancePTNotificationSetToProxy() throws Exception {
        assertThat("Нотификации баланса настроены не на прокси сервис " + PROXY_URL
                , new UnitTestLib(Environment.GREED_PT).getXmlrpcProxyUrlDirect(), equalTo(PROXY_URL));
    }
}
