package ru.yandex.autotests.direct.handles.monitorings;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;

/**
 * Created by buhter on 22.01.14.
 */
@Aqua.Test(title = "Проверка ответа от xmlrpc прокси-сервиса", description = "Проверка ответа от xmlrpc прокси-сервиса")
@Feature("NotificationMonitorings")
public class XmlRpcConnectionAliveTest {
    @Rule
    public BottleMessageRule bottleMessageRule = new BottleMessageRule();

    private Client client;
    @Before
    public void initClient(){
        client = Client.create();
    }

    @Test
    public void checkNotification(){
        assertThat("Проблемы с прокси сервисом на http://ppctest-handles.ppc.yandex.ru", client
                .resource("http://ppctest-handles.ppc.yandex.ru/xmlrpc/proxy/").accept("text/xml")
                .post(ClientResponse.class).getStatus(), equalTo(200));
    }

    @After
    public void  destroyClient(){
        client.destroy();
    }
}
