package ru.yandex.autotests.direct.handles.rest;

import org.eclipse.jetty.server.*;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyDebugStarter {
    // При локальном запуске нужно указать полный путь к war-файлу
    // Н-р: "/Users/gukserg/arc/arcadia/direct/qa/direct-handles-web/direct-handles-rest/target/direct-handles-rest.war"
    private static final String WAR_PATH = "/Users/gukserg/arc/arcadia/direct/qa/direct-handles-web/direct-handles-rest/target/direct-handles-rest.war";
    // Приложение будет на http://localhost:9002/
    // Проверка: curl http://localhost:9002/test
    private static final String CONTEXT_PATH = "/";
    private static final int PORT = 9002;

    public static void main(String... args) throws Exception {
        Server server = new Server();
        server.setConnectors(new Connector[]{buildConnector(server)});
        server.setHandler(buildHandlers());
        server.start();
    }


    private static Connector buildConnector(Server server) {
        ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(new HttpConfiguration()));
        http.setPort(PORT);
        return http;
    }


    private static Handler buildHandlers() {
        return buildWebAppContextHandler();
    }


    private static WebAppContext buildWebAppContextHandler() {
        return new WebAppContext(WAR_PATH, CONTEXT_PATH);
    }
}
