package ru.yandex.autotests.direct.handles.rest.providers;

import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * Мапит все исключения, которые не мапятся остальными мапперами, на ответ с кодом 500 и стэктрейсом
 * User: mexicano
 * Date: 09.04.14
 */
@Provider
public class DefaultExceptionMapper implements ExceptionMapper<Throwable> {

    @Override
    public Response toResponse(Throwable exception) {
        return Response
                .status(Response.Status.INTERNAL_SERVER_ERROR)
                .entity(ExceptionUtils.getStackTrace(exception))
                .build();
    }
}
