package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.AddEventsService;
import ru.yandex.autotests.direct.handles.beans.EventItemBean;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * Created by chicos on 06.03.14
 */
@Component
@Path("/add-events")
public class AddEventsRestService {

    @Autowired
    private AddEventsService addEventService;

    @PUT
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/add/")
    public void addEvent(EventItemBean eventItemBean) {
        addEventService.addEvent(eventItemBean);
    }
}
