package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.SemaphoreService;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: azee
 * Date: 2/20/13
 * Time: 6:08 PM
 */
@Component
@Path("/autotests")
public class AutotestsRestService {

    @Autowired
    private SemaphoreService semaphoreService;

    @GET
    @Consumes({MediaType.TEXT_PLAIN})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/get-semaphore-perm")
    public List<String> getSemaphoreAvailablePermits(@QueryParam("semaphoreNames") String semaphoreNames) {
        return semaphoreService.getSemaphoreAvailablePermits(semaphoreNames);
    }

    @GET
    @Path("/release-semaphore-perm")
    public void releaseSemaphorePermits(@QueryParam("semaphoreName") String semaphoreName,
                                        @QueryParam("permits") String permits) {
        semaphoreService.releaseSemaphorePermits(semaphoreName, permits);
    }

    @GET
    @Path("/reduce-semaphore-perm")
    public void reduceSemaphorePermits(@QueryParam("semaphoreName") String semaphoreName,
                                       @QueryParam("permits") String permits) {
        semaphoreService.reduceSemaphorePermits(semaphoreName, permits);
    }
}
