package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.BalanceClientService;
import ru.yandex.autotests.direct.handles.beans.BalanceClientBean;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * Author buhter
 * Date 07.05.14
 */
@Component
@Path("/balance-client")
public class BalanceClientRestService {

    @Autowired
    private BalanceClientService balanceClientService;

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/update/")
    public BalanceClientBean updateClient(BalanceClientBean balanceClientBean) {
        return balanceClientService.updateClient(balanceClientBean);
    }

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/get-info/")
    public BalanceClientBean getClientInfo(BalanceClientBean balanceClientBean) {
        return balanceClientService.getClientInfo(balanceClientBean);
    }

    @GET
    @Path("/turn-on-invoice/")
    public void turnOnInvoice(@QueryParam("invoiceId") int invoiceId,
                              @QueryParam("balanceStage") String balanceStage) {
        balanceClientService.turnOnInvoice(invoiceId, balanceStage);
    }

    @GET
    @Path("/do-campaigns/")
    public void doCampaings(@QueryParam("orderId") String orderId,
                            @QueryParam("qty") double qty,
                            @QueryParam("balanceStage") String balanceStage) {
        balanceClientService.doCampaings(orderId, qty, balanceStage);
    }

    @GET
    @Produces({MediaType.TEXT_PLAIN})
    @Path("/get-overdraft-limit/")
    public String  getOverdraftLimit(@QueryParam("login") String login,
                                     @QueryParam("balanceStage") String balanceStage) {
        return balanceClientService.getClientOverdraft(login, balanceStage);
    }

    @GET
    @Produces({MediaType.TEXT_PLAIN})
    @Path("/get-available-overdraft/")
    public String getAvailableOverdraft(@QueryParam("login") String login,
                                        @QueryParam("orderId") int orderId,
                                        @QueryParam("balanceStage") String balanceStage) {
        return balanceClientService.getAvailableOverdraft(login, orderId, balanceStage);
    }

}
