package ru.yandex.autotests.direct.handles.rest.resources;

import java.util.LinkedList;
import java.util.List;

import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autotests.direct.scriptrunner.service.bslogs.BsLogsService;

@Component
@Singleton
@Path("bslogs")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class BsLogsRestService {

    private static final String UUID_SEP = ",";

    @Autowired
    private BsLogsService bsLogsService;

    @GET
    public String getBsLogs(@QueryParam("beta-host") String betaHost,
                            @QueryParam("date") String date,
                            @QueryParam("method") String method,
                            @QueryParam("shard") Integer shard,
                            @QueryParam("uuid") String uuid,
                            @QueryParam("campaignId") Long cid) {
        String[] uuidArr = uuid.split(UUID_SEP);
        List<String> uuidList = new LinkedList<>();
        for (String uuidStr : uuidArr) {
            String uuidNormalized = uuidStr.trim();
            if (!uuidNormalized.isEmpty()) {
                uuidList.add(uuidNormalized);
            }
        }

        return bsLogsService.getBsLogs(betaHost, date, method, shard,
                cid, uuidList.toArray(new String[uuidList.size()]));    }
}
