package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.CreateClientsService;
import ru.yandex.autotests.direct.handles.beans.ClientsBean;
import ru.yandex.autotests.direct.handles.beans.CurrencyUserBean;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * User: buhter
 * Date: 16.09.13
 * Time: 12:57
 */
@Component
@Path("/create-clients")
public class CreateClientsRestService {

    @Autowired
    private CreateClientsService createClientService;

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/base/")
    public ClientsBean baseCreateClients(ClientsBean clientsBean) {
        return createClientService.createBase(clientsBean);
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/specified/")
    public ClientsBean createSpecifiedClients(ClientsBean clientsBean) {
        return createClientService.createSpecified(clientsBean);
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/currency/")
    public List<String[]> createCurrencyClient(CurrencyUserBean clientBean) {
        return createClientService.create(clientBean, false);
    }

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/token/")
    public List<String[]> createTokenClient(CurrencyUserBean userBean) {
        return createClientService.create(userBean, true);
    }
}
