package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.GetCampaignsService;
import ru.yandex.autotests.direct.handles.beans.AccountBean;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Component
@Path("/get-campaigns")
public class GetCampaignsRestService {

    @Autowired
    private GetCampaignsService getCampaignsService;

    @POST
    @Produces({MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON})
    public AccountBean getCampaigns(AccountBean accountBean) {
        return getCampaignsService.getCampaigns(accountBean);
    }
}
