package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.MongoTextResourceService;
import ru.yandex.autotests.direct.handles.beans.MongoTextResourceBean;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * User: buhter
 * Date: 28.11.13
 * Time: 12:35
 */
@Component
@Path("/mongo-text-resource")
public class MongoTextResourceResource {

    @Autowired
    private MongoTextResourceService mongoTextResourceService;

    @GET
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/load/")
    public MongoTextResourceBean loadTextResourceFromMongo(@QueryParam("resourceName") String resourceName) {
        return mongoTextResourceService.loadTextResourceFromMongo(resourceName);
    }

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/save/")
    public MongoTextResourceBean saveTextResourceInMongo(MongoTextResourceBean mongoTextResourceBean) {
        return mongoTextResourceService.saveTextResourceInMongo(mongoTextResourceBean);
    }

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/search/")
    public List<MongoTextResourceBean> searchTextResourceInMongo(MongoTextResourceBean mongoTextResourceBean) {
        return mongoTextResourceService.searchTextResourceInMongo(mongoTextResourceBean);
    }

//    @POST
//    @Consumes({MediaType.APPLICATION_JSON})
//    @Path("/remove/")
//    public MongoTextResourceBean removeUserFromMongo(MongoTextResourceBean mongoTextResourceBean)
//            throws DirectHandlesException {
//        try {
//            return mongoTextResourceService.removeTextResourceFromMongo(mongoTextResourceBean);
//        } catch (Exception e) {
//            throw new DirectHandlesException(e);
//        }
//    }
}
