package ru.yandex.autotests.direct.handles.rest.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.MongoUserService;
import ru.yandex.autotests.direct.handles.beans.MongoUserBean;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * User: buhter
 * Date: 28.11.13
 * Time: 12:35
 */
@Component
@Path("/mongo-user")
public class MongoUserResource {

    @Autowired
    private MongoUserService mongoUserService;

    @GET
    @Path("{login}")
    @Produces({MediaType.APPLICATION_JSON})
    public MongoUserBean loadUserFromMongoByLogin(@PathParam("login") String login) {
        return mongoUserService.getMongoUser(login);
    }

    @PUT
    @Path("{login}")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    public MongoUserBean saveUser(@PathParam("login") String login, MongoUserBean mongoUserBean) {
            return mongoUserService.saveUserInMongo(mongoUserBean);
    }

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("/remove/")
    public MongoUserBean removeUserFromMongo(MongoUserBean mongoUserBean) {
        return mongoUserService.removeUserFromMongo(mongoUserBean);
    }

    @GET
    @Path("/generate-token/")
    public void generateTokenForLogin(@QueryParam("login") String login) {
        mongoUserService.generateTokenForLogin(login);
    }
}
