package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.SendMailService;
import ru.yandex.autotests.direct.handles.service.utils.MailUtils;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;

/**
 * User: buhter
 * Date: 11.10.13
 * Time: 14:42
 */
@Component
@Path("/mail")
public class SendMailRestService {

    @Autowired
    private SendMailService sendMailService;

    @GET
    @Path("/send")
    public void send(@QueryParam("to") String addressTo,
                     @QueryParam("subj") String subject,
                     @QueryParam("text") String textMessage) throws AddressException {
        MailUtils.sendMail(InternetAddress.parse(addressTo), subject, textMessage);
    }

    @GET
    @Path("/send-from-jenkins")
    public void sendFromJenkins(@QueryParam("to") String addressTo,
                                @QueryParam("subj") String subject,
                                @QueryParam("launchInfo") String launchInfo) throws AddressException {
        sendMailService.sendMailFromJenkins(addressTo, subject, launchInfo);
    }

    @GET
    @Path("/send-unfinished-launches")
    public void sendMailAboutUnfinishedPacks(@QueryParam("to") String addressTo) throws AddressException {
        sendMailService.sendMailAboutUnfinishedPacks(addressTo);
    }
}