package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.scriptrunner.service.shard.ShardService;

import javax.inject.Singleton;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Component
@Singleton
@Path("shard")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class ShardRestService {

    @Autowired
    private ShardService shardService;

    @GET
    public Integer getShard(@QueryParam("beta-host") String betaHost,
                            @QueryParam("cid") Long cid) {
        return shardService.getShardByCid(betaHost, cid);
    }
}