package ru.yandex.autotests.direct.handles.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.ShardUserService;
import ru.yandex.autotests.direct.handles.beans.ShardUserBean;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * User: buhter
 * Date: 28.11.13
 * Time: 12:35
 */
@Component
@Path("/shard-user")
public class ShardUserRestService {

    @Autowired
    private ShardUserService shardUserService;

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/get/")
    public ShardUserBean getUserShard(ShardUserBean shardUserBean) {
        return shardUserService.getUserShard(shardUserBean);
    }

    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @Path("/reshard/")
    public ShardUserBean reshardUser(ShardUserBean shardUserBean) {
        return shardUserService.reshardUser(shardUserBean);
    }
}
