package ru.yandex.autotests.direct.handles.rest.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.handles.service.utils.MailUtils;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.ws.rs.*;

@Component
@Path("/test")
public class TestRestService {

    @GET
    public String addEvent() {
        return "It is good.";
    }

    @GET
    @Path("/say")
    public void send(@QueryParam("level") String level,
                     @QueryParam("text") String textMessage) throws AddressException {
        Logger log = LoggerFactory.getLogger(this.getClass());
        switch (level) {
            case "info":
                log.info(textMessage);
                break;
            case "warn":
                log.warn(textMessage);
                break;
            case "error":
                log.error(textMessage);
                break;
            case "trace":
                log.trace(textMessage);
                break;
            case "debug":
                log.debug(textMessage);
                break;
            default:
                log.error("Unknown level" + textMessage);
        }

    }
}
