package ru.yandex.autotests.direct.handles.service;

import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

import ru.yandex.autotests.direct.handles.beans.EventItemBean;
import ru.yandex.autotests.direct.handles.service.utils.StepsHelper;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;

/**
 * Created by chicos on 03.03.14
 */
@Service
public class AddEventsService {

    private ApiSteps apiSteps;

    public void addEvent(EventItemBean eventBean) {
        apiSteps = StepsHelper.getApiSteps(eventBean.getStage());
        EventsLogItemMap eventMap = getEventItemMap(eventBean);
        StepsHelper.getDarksideSteps(eventBean.getStage()).getEventLogFakeSteps().addEvents((EventsLogItem) eventMap.getBean());
    }

    private EventsLogItemMap getEventItemMap(EventItemBean eventBean) {
        EventsLogItemMap eventMap = new EventsLogItemMap(apiSteps.type());
        BannerPhraseInfoMap bannerPhraseMap = new BannerPhraseInfoMap(apiSteps.type());
        switch (eventBean.getType()) {
            case BANNER_MODERATED:
                eventMap.bannerModeratedEvent(eventBean.getCampaignId(),
                        eventBean.getBannerId(),
                        eventBean.getModerationResult(),
                        eventBean.getIsEditedByModerator());
                break;
            case CAMPAIGN_FINISHED:
                eventMap.campaignFinishedEvent(eventBean.getCampaignId(),
                        new DateTime(eventBean.getFinishDate()).toDate());
                break;
            case MONEY_OUT:
                eventMap.moneyOutEvent(eventBean.getCampaignId(),
                        DateTime.now().toString());
                break;
            case MONEY_WARNING:
                if (eventBean.getCurrency().equals("YND_FIXED")) {
                    eventBean.setCurrency(null);
                }
                eventMap.moneyWarningEvent(eventBean.getCampaignId(),
                        eventBean.getRest(),
                        eventBean.getCurrency());
                break;
            case MONEY_IN:
                if (eventBean.getCurrency().equals("YND_FIXED")) {
                    eventBean.setCurrency(null);
                }
                eventMap.moneyInEvent(eventBean.getCampaignId(),
                        eventBean.getPayed(),
                        eventBean.getCurrency()
                );
                break;
            case MONEY_OUT_ACCOUNT:
                eventMap.moneyOutAccountEvent(eventBean.getAccountId(),
                        DateTime.now().toString());
                break;
            case MONEY_WARNING_ACCOUNT:
                if (eventBean.getCurrency().equals("YND_FIXED")) {
                    eventBean.setCurrency(null);
                }
                eventMap.moneyWarningAccountEvent(eventBean.getAccountId(),
                        eventBean.getRest(),
                        eventBean.getCurrency());
                break;
            case MONEY_IN_ACCOUNT:
                if (eventBean.getCurrency().equals("YND_FIXED")) {
                    eventBean.setCurrency(null);
                }
                eventMap.moneyInAccountEvent(eventBean.getAccountId(),
                        eventBean.getPayed(),
                        eventBean.getCurrency()
                );
                break;
            case PAUSED_BY_DAY_BUDGET:
                eventMap.pausedByDayBudgetEvent(eventBean.getCampaignId(),
                        new DateTime(eventBean.getStopTime()).toString("yyyy-MM-dd'T'hh:mm:ss")
                );
                break;
            case PAUSED_BY_DAY_BUDGET_ACCOUNT:
                eventMap.pausedByDayBudgetAccountEvent(eventBean.getAccountId(),
                        new DateTime(eventBean.getStopTime()).toString("yyyy-MM-dd'T'hh:mm:ss")
                );
                break;
            case WARN_PLACE:
                bannerPhraseMap.clear();
                eventMap.warnPlaceEvent(bannerPhraseMap
                                .withCampaignId(Integer.toString(eventBean.getCampaignId()))
                                .withBannerId(Long.toString(eventBean.getBannerId()))
                                .withPhraseId(Long.toString(eventBean.getPhraseId())),
                        Integer.toString(eventBean.getOldPlace())
                );
                break;
            default:
                break;
        }
        return eventMap;
    }
}

