package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.handles.beans.CreateCampaignsBean;
import ru.yandex.autotests.direct.handles.service.utils.StepsHelper;
import ru.yandex.autotests.directapi.rules.ApiSteps;

import java.util.Random;

/**
 * User: buhter
 * Date: 10.09.13
 * Time: 12:34
 */
@Service
public class CreateCampaignsService {
    public CreateCampaignsBean createCampaigns(CreateCampaignsBean createCampaignsBean) {
        ApiSteps apiSteps = StepsHelper.getApiSteps(createCampaignsBean.getStage());
        createCampaignsBean.getCampaigns().clear();
        int bannersAmount;
        int campaignID;
        int status;
        if(createCampaignsBean.getBannersTo() == 0){
            bannersAmount = createCampaignsBean.getBannersFrom();
        } else{
            bannersAmount = new Random().nextInt(createCampaignsBean.getBannersTo()
                    - createCampaignsBean.getBannersFrom() + 1) + createCampaignsBean.getBannersFrom();
        }
        if (!createCampaignsBean.getInternalLogin().equals("")){
            apiSteps.as("at-direct-super", createCampaignsBean.getInternalLogin());
        }
        for(int i = 0; i < createCampaignsBean.getCampaignsAmount(); i ++){
            status = createCampaignsBean.getCampaignStatus();
            campaignID = createCampaign(apiSteps, status, bannersAmount, createCampaignsBean.getLogin());
            if (createCampaignsBean.getCampaignValue() > 0){
                apiSteps.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(campaignID
                        , createCampaignsBean.getCampaignValue(), null);
            }

            createCampaignsBean.getCampaigns().add(campaignID);
        }
        return createCampaignsBean;
    }

    private double getProbability(int percent) {
        return percent * 0.01d;
    }

    private void addBanners(ApiSteps apiSteps, int campaignID, int bannersAmount, int status){
        if (bannersAmount > 1){
            for(int j = 1; j < bannersAmount; j ++){
                Long bannerID = apiSteps.userSteps.bannerSteps().createDefaultBanner(campaignID);
                switch (status){
                    case 0:
                        apiSteps.userSteps.bannersFakeSteps().makeBannerActive(bannerID);
                        break;
                    case 2:
                        apiSteps.userSteps.bannersFakeSteps().makeBannersModerated(bannerID);
                        break;
                    default:
                        break;
                }
            }
        }
    }


    private int createCampaign(ApiSteps apiSteps, int status, int bannersAmount, String login) {
        int campaignID;
        if(status == 0){
            status  = new Random().nextInt(5) + 1;
        }
        switch (status){
            case 1:
                campaignID = apiSteps.userSteps.createActiveCampaign(login);
                addBanners(apiSteps, campaignID, status, bannersAmount);
                break;
            case 2:
                campaignID = apiSteps.userSteps.createDraftCampaign(login);
                addBanners(apiSteps, campaignID, status, bannersAmount);
                break;
            case 3:
                campaignID = apiSteps.userSteps.createModeratedCampaign(login);
                addBanners(apiSteps, campaignID, status, bannersAmount);
                break;
            case 4:
                campaignID = apiSteps.userSteps.createDraftCampaign(login);
                addBanners(apiSteps, campaignID, status, bannersAmount);
                apiSteps.userSteps.makeCampaignDeclined(campaignID);
                break;
            case 5:
                campaignID = apiSteps.userSteps.createStoppedCampaign(login, bannersAmount);
                break;
            default:
                throw new IllegalStateException("Ошибка при создании кампании");
        }
        return campaignID;
    }
}
