package ru.yandex.autotests.direct.handles.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Service;

import ru.yandex.aqua.beans.Launch;
import ru.yandex.aqua.beans.LaunchStatus;
import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.cmd.data.CmdBeansMaps;
import ru.yandex.autotests.direct.cmd.data.banners.GroupsParameters;
import ru.yandex.autotests.direct.cmd.data.commons.group.Group;
import ru.yandex.autotests.direct.cmd.data.groups.GroupsFactory;
import ru.yandex.autotests.direct.cmd.data.phrases.PhrasesFactory;
import ru.yandex.autotests.direct.cmd.data.savecamp.SaveCampRequest;
import ru.yandex.autotests.direct.cmd.steps.base.DirectStepsContext;
import ru.yandex.autotests.direct.cmd.steps.oauth.OAuthSteps;
import ru.yandex.autotests.direct.cmd.util.BeanLoadHelper;
import ru.yandex.autotests.direct.handles.beans.AccountInfo;
import ru.yandex.autotests.direct.handles.beans.ClientsBean;
import ru.yandex.autotests.direct.handles.beans.CurrencyUserBean;
import ru.yandex.autotests.direct.handles.service.utils.aqua.Aqua;
import ru.yandex.autotests.direct.handles.service.utils.constants.AquaStage;
import ru.yandex.autotests.direct.handles.service.utils.constants.UtilConstants;
import ru.yandex.autotests.direct.handles.service.utils.mongo.AccountsMongoHelper;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.directapi.exceptions.UserNotFoundException;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.httpclientlite.context.ConnectionContext;
import ru.yandex.autotests.irt.restheart.client.RestheartClientProperties;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.direct.handles.service.utils.StepsHelper.getDirectCmdSteps;
import static ru.yandex.autotests.direct.handles.service.utils.StepsHelper.getDirectHost;

/**
 * User: buhter
 * Date: 16.09.13
 * Time: 12:36
 */
@Service
public class CreateClientsService {

    public static final String PACKAGE_NAME = "ru.yandex.autotests.direct.handles.aquahelper";
    private DirectCmdSteps directCmdSteps;


    public ClientsBean createBase(ClientsBean clientsBean) {
        //Set pack properties
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("accounts.amount", String.valueOf(clientsBean.getClientsAmount()));
        return create(clientsBean, "BaseCreateAccounts", properties);
    }

    public ClientsBean createSpecified(ClientsBean clientsBean) {
        //Set pack properties
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("login.prefix", String.valueOf(clientsBean.getLoginPrefix()));
        properties.put("login.postfix.start", clientsBean.getLoginPostfixStart());
        properties.put("login.postfix.end", clientsBean.getLoginPostfixEnd());
        properties.put("password", String.valueOf(clientsBean.getPassword()));
        return create(clientsBean, "CreateSpecifiedAccounts", properties);
    }

    private ClientsBean create(ClientsBean clientsBean, String testClassName, HashMap<String, String> properties) {
        //Generation uuid for search aqua results in mongo. Aqua gets it via pack properties
        String sessionUUID = UUID.randomUUID().toString();
        properties.put("session.uuid", sessionUUID);
        properties.put("mongo.http.host", RestheartClientProperties.get().getHost());

        //Get our aqua client
        Aqua aqua = new Aqua(AquaStage.AQUA_BASE_URL);
        //Launch pack
        Launch launch = aqua.launchDirectHandlesTestClass(testClassName, PACKAGE_NAME, properties);
        //Wait pack to finish
        while (launch.getLaunchStatus() != LaunchStatus.FINISHED) {
            launch = aqua.updateLaunch(launch);
            sleep(5000);
        }
        if (launch.getFailedSuites() > 0) {
            throw new AquaTestException("Не удалось создать аккаунт. Не прошел тест на акве: " + launch.getLaunchUrl());
        }
        AccountsMongoHelper accountsMongoHelper = new AccountsMongoHelper();
        List<User> accounts = accountsMongoHelper.getUserBySandboxToken(sessionUUID);
        for (User account : accounts) {
            AccountInfo accountInfo = new AccountInfo();
            accountInfo.setLogin(account.getLogin());
            accountInfo.setPassword(account.getPassword());
            clientsBean.getAccounts().add(accountInfo);
            accountsMongoHelper.deleteMongoBean(accountsMongoHelper.getUniqueFilter(account));
        }
        //Clean mongo
        return clientsBean;
    }

    public List<String[]> create(CurrencyUserBean currencyUserBean, Boolean token) {
        List<String[]> resultTable = new ArrayList<>();
        for (String login : currencyUserBean.getLogin().split(",")) {
            resultTable.addAll(create(currencyUserBean, login, token));
        }
        return resultTable;
    }

    public List<String[]> create(CurrencyUserBean currencyUserBean, String login, Boolean token) {
        MongoUser user = new MongoUser();
        String password = currencyUserBean.getPassword();
        if (!currencyUserBean.isInPassport()) {
            user.setLogin(login);
            user.setPassword(password);
            ClientsBean clientsBean = new ClientsBean();
            clientsBean.setClientsAmount("1");
            clientsBean.setLoginPrefix(login);
            clientsBean.setPassword(currencyUserBean.getPassword());
            createSpecified(clientsBean);
        } else {
            user = MongoUser.get(login);
            if (user.getPassword() == null) {
                throw new UserNotFoundException("Пользователь с логином " + login +
                        " не найден в монго или пустой пароль");
            }
            password = user.getPassword();
        }

        String authStage = "TS";
        if (!currencyUserBean.getStages().contains(authStage)) {
            for (String stage : currencyUserBean.getStages()) {
                if (stage.matches("\\d+")) {
                    authStage = stage;
                    break;
                }
            }
        }

        directCmdSteps = getDirectCmdSteps(authStage);
        directCmdSteps.authSteps().authenticate(new User(user));

        if (token) {
            DirectStepsContext context = new DirectStepsContext()
                    .withProperties(DirectTestRunProperties.getInstance());
            context.useConnectionContext(new ConnectionContext().scheme("https").host("oauth.yandex.ru"));
            OAuthSteps oAuthSteps = OAuthSteps.getInstance(OAuthSteps.class, context);
            oAuthSteps.auth(login, password);
            user.setToken(oAuthSteps.getTokenForApp(UtilConstants.DIRECT_API_APP));
        }
        MongoUser.saveUser(user);

        List<String[]> resultTable = new ArrayList<>();
        for (String stage : currencyUserBean.getStages()) {
            directCmdSteps.context().getConnectionContext()
                    .host(getDirectHost(stage).replace("https://", ""));
            try {
                createFirstCampaign(
                        user,
                        String.valueOf(currencyUserBean.getCountry()),
                        currencyUserBean.getCurrency(), "std");
                resultTable.add(new String[]{login + ": " + stage, "ОК"});
            } catch (Throwable e) {
                resultTable.add(new String[]{login + ": " + stage, "ERROR: " + ExceptionUtils.getStackTrace(e)});
            }
        }
        return resultTable;
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void createFirstCampaign(MongoUser user, String country, String currency, String interfaceType) {

        try {
            directCmdSteps.сlientsSteps().ajaxCreateClient(Long.valueOf(country), currency, user.getLogin());
        } catch (Exception e) {
            //ну и пофиг, что валюта уже выбрана
        }

        SaveCampRequest saveCampRequest = BeanLoadHelper.loadCmdBean(
                CmdBeansMaps.MEDIA_TYPE_TO_TEMPLATE.get(CampaignTypeEnum.TEXT), SaveCampRequest.class);
        saveCampRequest.setMediaType(CampaignTypeEnum.TEXT.getValue());
        saveCampRequest.setUlogin(user.getLogin());
        saveCampRequest.setClientCountry(country);
        saveCampRequest.setCurrency(currency);
        saveCampRequest.setInterfaceType(interfaceType);
        Long campaignId = directCmdSteps.campaignSteps().saveNewCampaign(saveCampRequest);

        Group group = GroupsFactory.getDefaultTextGroup()
                .withPhrases(new ArrayList<>(singletonList(PhrasesFactory.getDefaultEngPhrase())));
        group.setCampaignID(campaignId.toString());
        group.getBanners().get(0).withCid(campaignId);
        GroupsParameters groupRequest = GroupsParameters.forNewCamp(
                user.getLogin(), campaignId, group);

        directCmdSteps.groupsSteps().postSaveTextAdGroups(groupRequest);
    }

    private static final class AquaTestException extends RuntimeException {

        private AquaTestException(String message) {
            super(message);
            setStackTrace(new StackTraceElement[0]);
        }
    }

}

