package ru.yandex.autotests.direct.handles.service;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Service;

import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.cmd.data.Logins;
import ru.yandex.autotests.direct.handles.beans.DeleteCampaignsBean;
import ru.yandex.autotests.direct.handles.service.utils.StepsHelper;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;

import static ru.yandex.autotests.direct.httpclient.TestEnvironment.newDbSteps;

@Service
public class DeleteCampaignsService {
    public DeleteCampaignsBean deleteCampaignsByID(DeleteCampaignsBean deleteCampaignsBean) {
        List<Long> campaignIds = StreamEx.split(deleteCampaignsBean.getCampaigns().replace(" ", ""), ',')
                .map(Long::parseLong)
                .toList();
        return deleteCampaignsList(deleteCampaignsBean, campaignIds);
    }

    public DeleteCampaignsBean deleteCampaignsByLogin(DeleteCampaignsBean deleteCampaignsBean) {
        DirectCmdSteps cmdSteps =
                StepsHelper.getDirectCmdSteps(deleteCampaignsBean.getStage());
        cmdSteps.authSteps().authenticate(User.get(Logins.SUPER));

        List<Long> campaignIds = cmdSteps.campaignSteps().getClientCampaigns(deleteCampaignsBean.getLogin());
        return deleteCampaignsList(deleteCampaignsBean, campaignIds);
    }
    private DeleteCampaignsBean deleteCampaignsList(DeleteCampaignsBean deleteCampaignsBean, List<Long> campaignIds) {
        ApiSteps apiSteps = StepsHelper.getApiSteps(deleteCampaignsBean.getStage());
        DirectCmdSteps cmdSteps =
                StepsHelper.getDirectCmdSteps(deleteCampaignsBean.getStage());
        cmdSteps.authSteps().authenticate(User.get(Logins.SUPER));
        deleteCampaignsBean.getResultDatas().clear();
        for (Long campaignId : campaignIds) {
            boolean result = true;
            try {
                deleteCampById(apiSteps, cmdSteps, campaignId);
            } catch (Exception e) {
                result = false;
                deleteCampaignsBean.getResultDatas().add("При удалении кампании " + campaignId + " произошла ошибка: " +
                        e.getMessage());
            }
            if (result) {
                deleteCampaignsBean.getResultDatas().add("Кампания " + campaignId + " успешно удалена");
            }
        }
        return deleteCampaignsBean;
    }

    private void deleteCampById(ApiSteps apiSteps, DirectCmdSteps cmdSteps, Long campaignId) {
        apiSteps.userSteps.campaignFakeSteps().makeCampaignReadyForDelete(campaignId);

        cmdSteps.campsMultiActionSteps().deleteCampaigns(getLoginByCid(campaignId), campaignId);
    }

    private String getLoginByCid(Long campaignId) {
        newDbSteps().useShard(newDbSteps().shardingSteps().getShardByCid(campaignId));
        return newDbSteps().usersSteps().getUsers(
                newDbSteps().campaignsSteps().getCampaignById(campaignId).getUid()
        ).getLogin();
    }
}
