package ru.yandex.autotests.direct.handles.service;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.handles.beans.AccountBean;
import ru.yandex.autotests.direct.handles.service.utils.StepsHelper;
import ru.yandex.autotests.directapi.common.api45.ShortCampaignInfo;
import ru.yandex.autotests.directapi.rules.ApiSteps;

/**
 * Created with IntelliJ IDEA.
 * User: buhter
 * Date: 10.09.13
 * Time: 12:34
 */
@Service
public class GetCampaignsService {
    public AccountBean getCampaigns(AccountBean accountBean){
        ApiSteps apiSteps = StepsHelper.getApiSteps(accountBean.getStage());
        List<CampaignGetItem> campaignInfoList = apiSteps.userSteps.campaignSteps().getCampaigns(accountBean.getLogin());
        accountBean.getCampaigns().clear();
        for (CampaignGetItem shortCampaignInfo: campaignInfoList){
            accountBean.getCampaigns().add(shortCampaignInfo.getId());
        }
        return accountBean;
    }
}
