package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.handles.beans.MongoTextResourceBean;
import ru.yandex.autotests.direct.utils.beans.TextResourceBean;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by buhter on 27.01.14.
 */
@Service
public class MongoTextResourceService {
    public MongoTextResourceBean saveTextResourceInMongo(MongoTextResourceBean mongoTextResourceBean) {
        if (mongoTextResourceBean.getResourceName().equals("")){
            throw new IllegalArgumentException("Не могу искать по пустому ключу");
        }
        TextResourceBean resourceBean = TextResources.getBean(mongoTextResourceBean.getResourceName());
        if(resourceBean == null) {
            resourceBean = new TextResourceBean();
            resourceBean.setEn("");
            resourceBean.setRu("");
        }

        if(mongoTextResourceBean.getEnglishValue().equals("null")){
            resourceBean.setEn("");
        } else if(!mongoTextResourceBean.getEnglishValue().equals("")){
            resourceBean.setEn(mongoTextResourceBean.getEnglishValue());
        }

        if(mongoTextResourceBean.getRussianValue().equals("null")){
            resourceBean.setRu("");
        } else if(!mongoTextResourceBean.getRussianValue().equals("")){
            resourceBean.setRu(mongoTextResourceBean.getRussianValue());
        }

        mongoTextResourceBean.setEnglishValue(resourceBean.getEn());
        mongoTextResourceBean.setRussianValue(resourceBean.getRu());
        TextResources.saveTextResource(resourceBean, mongoTextResourceBean.getResourceName());
        return mongoTextResourceBean;
    }

    public MongoTextResourceBean loadTextResourceFromMongo(String resourceName) {
        if (resourceName.equals("")) {
            throw new IllegalArgumentException("Не могу искать по пустому ключу");
        }
        TextResourceBean resourceBean = TextResources.getBean(resourceName);
        if (resourceBean == null) {
            throw new IllegalArgumentException("Не удалось получить текстовые ресурсы из монго по ключу "
                    + resourceName);
        }
        MongoTextResourceBean mongoTextResourceBean = new MongoTextResourceBean();
        mongoTextResourceBean.setResourceName(resourceName);
        mongoTextResourceBean.setRussianValue(resourceBean.getRu());
        mongoTextResourceBean.setEnglishValue(resourceBean.getEn());
        return mongoTextResourceBean;
    }

    public List<MongoTextResourceBean> searchTextResourceInMongo(MongoTextResourceBean mongoTextResourceBean) {
        List<MongoTextResourceBean> suitableResources = new ArrayList<>();
        TextResourceBean resourceBean = new TextResourceBean();
        resourceBean.setKey(mongoTextResourceBean.getResourceName());
        resourceBean.setEn(mongoTextResourceBean.getEnglishValue());
        resourceBean.setRu(mongoTextResourceBean.getRussianValue());
        List<TextResourceBean> beans = TextResources.searchBeans(resourceBean);
        if (beans == null){
            return suitableResources;
        }
        for(TextResourceBean bean: beans){
            mongoTextResourceBean = new MongoTextResourceBean();
            mongoTextResourceBean.setResourceName(bean.getKey());
            mongoTextResourceBean.setRussianValue(bean.getRu());
            mongoTextResourceBean.setEnglishValue(bean.getEn());
            suitableResources.add(mongoTextResourceBean);
        }
        return suitableResources;
    }
}
