package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.cmd.steps.base.DirectStepsContext;
import ru.yandex.autotests.direct.cmd.steps.oauth.OAuthSteps;
import ru.yandex.autotests.direct.handles.beans.MongoUserBean;
import ru.yandex.autotests.direct.handles.service.utils.constants.UtilConstants;
import ru.yandex.autotests.direct.handles.service.utils.converters.UserToMongoBeanConverter;
import ru.yandex.autotests.direct.utils.beans.PropertyLoaderException;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.directapi.exceptions.UserNotFoundException;
import ru.yandex.autotests.httpclientlite.context.ConnectionContext;


/**
 * User: buhter
 * Date: 28.11.13
 * Time: 12:42
 */
@Service
public class MongoUserService {

    public MongoUserBean removeUserFromMongo(MongoUserBean mongoUserBean) {
        MongoUser.removeUser(mongoUserBean.getLogin());
        return mongoUserBean;
    }

    private String getDataOrEmpty(String data) {
        if (data == null || data.equals("") || data.equals("null")) {
            return "";
        } else {
            return data;
        }
    }

    public MongoUserBean saveUserInMongo(MongoUserBean mongoUserBean) {
        if (mongoUserBean.getLogin().equals("")) {
            throw new IllegalArgumentException("User login should not be empty");
        }
        MongoUser user;
        try {
            user = MongoUser.get(mongoUserBean.getLogin());
        } catch (UserNotFoundException e) {
            user = null;
        }

        if (user == null) {
            user = new MongoUser();
            user.setLogin(mongoUserBean.getLogin());
        }

        user.setPassword(getDataOrEmpty(mongoUserBean.getPassword()));

        user.setToken(getDataOrEmpty(mongoUserBean.getToken()));

        user.setPaymentToken(getDataOrEmpty(mongoUserBean.getPaymentToken()));

        user.setFinanceToken(getDataOrEmpty(mongoUserBean.getFinanceToken()));

        user.setSandboxToken(getDataOrEmpty(mongoUserBean.getSandboxToken()));

        if (mongoUserBean.getExpectedShard() > 0 && mongoUserBean.getExpectedShard() < 7) {
            user.setExpectedShard(mongoUserBean.getExpectedShard());
        } else {
            user.setExpectedShard(5);//5 - default shard
        }

        mongoUserBean.setPassword(user.getPassword());
        mongoUserBean.setToken(user.getToken());
        mongoUserBean.setPaymentToken(user.getPaymentToken());
        mongoUserBean.setFinanceToken(user.getFinanceToken());
        mongoUserBean.setSandboxToken(user.getSandboxToken());
        mongoUserBean.setExpectedShard(user.getExpectedShard());

        MongoUser.saveUser(user);
        return mongoUserBean;
    }

    public MongoUserBean getMongoUser(MongoUserBean mongoUserBean) {
        if (mongoUserBean != null) {
            return getMongoUser(mongoUserBean.getLogin());
        } else {
            throw new IllegalArgumentException("User login should not be empty");
        }
    }

    public MongoUserBean getMongoUser(String login) {
        if (login.equals("")) {
            throw new IllegalArgumentException("User login should not be empty");
        }
        MongoUser user;
        try {
            user = MongoUser.get(login);
        } catch (PropertyLoaderException e) {
            throw new IllegalStateException("User with login " + login + " not found in mongo");
        }
        return new UserToMongoBeanConverter().convert(user);
    }

    public void generateTokenForLogin(String login) {
        if (login.equals("")) {
            throw new IllegalArgumentException("User login should not be empty");
        }
        MongoUser user;
        try {
            user = MongoUser.get(login);
        } catch (PropertyLoaderException e) {
            throw new IllegalStateException("User with login " + login + " not found in mongo");
        }
        DirectStepsContext context = new DirectStepsContext();
        context.useConnectionContext(new ConnectionContext().scheme("https").host("oauth.yandex.ru"));
        OAuthSteps oAuthSteps = OAuthSteps.getInstance(OAuthSteps.class, context);
        oAuthSteps.auth(user.getLogin(), user.getPassword());
        user.setToken(oAuthSteps.getTokenForApp(UtilConstants.DIRECT_API_APP));
        MongoUser.saveUser(user);
    }

}
