package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.handles.service.utils.SemaphoreUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 12.08.14
 */

@Service
public class SemaphoreService {

    public List<String> getSemaphoreAvailablePermits(String semaphoreNames) {
        String[] semaphoreNameArray = semaphoreNames.replace(" ", "").split(",");
        return SemaphoreUtils.getSemaphoreAvailablePermits(Arrays.asList(semaphoreNameArray));
    }

    public void releaseSemaphorePermits(String semaphoreName,  String permits) {
            SemaphoreUtils.releaseSemaphorePermits(semaphoreName, Integer.valueOf(permits));
    }

    public void reduceSemaphorePermits(String semaphoreName, String permits) {
            SemaphoreUtils.reduceSemaphorePermits(semaphoreName, Integer.valueOf(permits));
    }
}
