package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.aqua.beans.Launch;
import ru.yandex.autotests.direct.handles.service.utils.MailUtils;
import ru.yandex.autotests.direct.handles.service.utils.TimeUtils;
import ru.yandex.autotests.direct.handles.service.utils.aqua.Aqua;
import ru.yandex.autotests.direct.handles.service.utils.constants.AquaStage;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Author buhter
 * Date 21.04.14
 */
@Service
public class SendMailService {

    public void sendMailFromJenkins(String addressTo, String subject, String launchInfoText) throws AddressException {
        StringBuilder messageBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("\\w{24}");
        Matcher matcher = pattern.matcher(launchInfoText);
        List<String> idList = new ArrayList<String>();
        while (matcher.find()) {
            idList.add(matcher.group());
        }
        Aqua aqua = new Aqua(AquaStage.AQUA_BASE_URL);
        for(int i = 0; i < idList.size(); i = i + 2){
            messageBuilder.append("Pack name: '")
                          .append(aqua.getPack(idList.get(i)).getName())
                          .append("'. Launch link: ")
                          .append(AquaStage.AQUA_BASE_URL)
                          .append("/#/launch?id=")
                          .append(idList.get(i +  1))
                          .append("\n");
        }
        MailUtils.sendMail(InternetAddress.parse(addressTo), subject, messageBuilder.toString());
    }

    public void sendMailAboutUnfinishedPacks(String addressTo) throws AddressException {
        StringBuilder messageBuilder = new StringBuilder();
        Launch lastLongLaunch = null;
        messageBuilder.append("Привет!")
                .append("\n\nОбнаружены запуски автотестов, которые выполняются слишком долго. Список паков: \n\n");
        Aqua aqua = new Aqua(AquaStage.AQUA_BASE_URL);
        List<List<Launch>> unfinishedLaunches = aqua.groupByPackID(aqua.getUnfinishedProjectLaunchesForLastTwoDays());
        for (List<Launch> launches : unfinishedLaunches) {
            lastLongLaunch = aqua.getLongestLaunch(launches);
            if (lastLongLaunch != null) {
                messageBuilder.append("Имя пака: '")
                        .append(lastLongLaunch.getPack().getName()+"'.")
                        .append(" " + AquaStage.AQUA_BASE_URL + "/#/pack/" + lastLongLaunch.getPack().getId())
                        .append("\nСсылка на последний долгий запуск: ")
                        .append(AquaStage.AQUA_BASE_URL+"/#/launch?id="+lastLongLaunch.getId())
                        .append("\nВремя выполнения: "+ TimeUtils.timePassed(new Date().getTime() -  lastLongLaunch.getStartTime()))
                        .append(" Кем запущено: "+lastLongLaunch.getUser())
                        .append(" Текущее состояние: " + lastLongLaunch.getLaunchStatus())
                        .append("\n\n\n");
            }
        }
        messageBuilder.append("Посмотреть более подробную информацию о текущих незавершенных запусках можно по ссылке: ")
                .append("http://ppctest-handles.ppc.yandex.ru/autotests/unfinishedLaunches.html");
        if (lastLongLaunch != null) {
            MailUtils.sendMail(InternetAddress.parse(addressTo),
                    "Долгие запуски тестов на Акве", messageBuilder.toString());
        }

    }
}
