package ru.yandex.autotests.direct.handles.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.handles.beans.ShardUserBean;

import static ru.yandex.autotests.direct.handles.service.utils.StepsHelper.getDarksideSteps;

/**
 * User: buhter
 * Date: 28.11.13
 * Time: 12:42
 */
@Service
public class ShardUserService {

    public ShardUserBean getUserShard(ShardUserBean shardUserBean) {
        shardUserBean.setShard(getDarksideSteps(shardUserBean.getStage())
                .getClientFakeSteps().getUserShard(shardUserBean.getLogin()));
        return shardUserBean;
    }

    public ShardUserBean reshardUser(ShardUserBean shardUserBean) {
        getDarksideSteps(shardUserBean.getStage()).getClientFakeSteps()
                .reshardUser(shardUserBean.getLogin(), shardUserBean.getShard());
        return getUserShard(shardUserBean);
    }
}
