package ru.yandex.autotests.direct.handles.service.utils;

import ru.yandex.autotests.direct.handles.service.utils.constants.RobotCredentials;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

/**
 * Created by buhter on 11.12.13.
 */
public class MailUtils {

    public static final String NOTIFICATIONS_MAIL_LIST = "direct-autotests-notifications@yandex-team.ru";
    public static final String RELEASE_MAIL_LIST = "direct-release@yandex-team.ru";
    public static final String DIRECT_AUTOTEST_DEV_MAIL_LIST = "direct-autotest-dev@yandex-team.ru";
    public static final String QA_IRT_MAIL_LIST = "qa-irt-team@yandex-team.ru";
    public static final String QA_IRT_AUTO_MAIL_LIST = "qa-irt-auto-team@yandex-team.ru";
    private static final String FROM_NAME = "Сервис Рукояточник";

    public static void sendMail(Address[] addressTo, String subject, String textMessage){
        Properties props = new Properties();
        props.put("mail.smtp.host", "smtp.yandex-team.ru");
        props.put("mail.smtp.socketFactory.port", "465");
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", "465");

        Session session = Session.getDefaultInstance(props,
                new javax.mail.Authenticator() {
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(RobotCredentials.LOGIN, RobotCredentials.PASSWORD);
                    }
                });
        try {
            Message message = new MimeMessage(session);
            try {
                message.setFrom(new InternetAddress(RobotCredentials.LOGIN + "@yandex-team.ru", FROM_NAME));
            } catch (UnsupportedEncodingException e) {
                message.setFrom(new InternetAddress(RobotCredentials.LOGIN + "@yandex-team.ru"));
            }
            message.setRecipients(Message.RecipientType.TO, addressTo);
            message.setSubject(subject);
            message.setText(textMessage);
            Transport.send(message);
        } catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}
