package ru.yandex.autotests.direct.handles.service.utils;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISemaphore;
import ru.yandex.qatools.hazelcast.HazelcastClient;

import java.util.LinkedList;
import java.util.List;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 08.08.14
 */
public class SemaphoreUtils {

    public static Integer getSemaphoreAvailablePermits(String semaphoreName) {
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        ISemaphore semaphore = client.getSemaphore(semaphoreName);
        Integer result = semaphore.availablePermits();
        client.shutdown();
        return result;
    }

    public static List<String> getSemaphoreAvailablePermits(List<String> semaphoreNames) {
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        ISemaphore semaphore;
        List<String> result = new LinkedList<String>();
        for (String semaphoreName : semaphoreNames) {
            semaphore = client.getSemaphore(semaphoreName);
            result.add(String.valueOf(semaphore.availablePermits()));
        }
        client.shutdown();
        return result;
    }

    //Уменьшить число фишек на permits не дожидаясь освобождения занятых.
    public static void reduceSemaphorePermits(String semaphoreName, int permits) {
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        ISemaphore semaphore = client.getSemaphore(semaphoreName);
        semaphore.reducePermits(permits);
        client.shutdown();
    }

    //увеличить число свободных фишек на permits
    public static void releaseSemaphorePermits(String semaphoreName, int permits) {
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        ISemaphore semaphore = client.getSemaphore(semaphoreName);
        semaphore.release(permits);
        client.shutdown();
    }
}
