package ru.yandex.autotests.direct.handles.service.utils;

import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.httpclientlite.context.ConnectionContext;

/**
 * User: buhter
 * Date: 04.10.13
 * Time: 13:05
 */
public class StepsHelper {
    public static ApiSteps getApiSteps(String stage) {
        return new ApiSteps().url(getDirectHost(stage));
    }

    public static DarkSideSteps getDarksideSteps(String stage) {
        return new DarkSideSteps(DirectTestRunProperties.newInstance().withDirectStage(stage));
    }

    public static DirectCmdSteps getDirectCmdSteps(String stage) {
        ConnectionContext connectionContext = new ConnectionContext().scheme("https").path("/registered/main.pl");
        connectionContext.host(getDirectHost(stage).replace("https://", ""));
        DirectCmdSteps directCmdSteps = new DirectCmdSteps();
        directCmdSteps.context().useConnectionContext(connectionContext);
        return directCmdSteps;
    }

    public static String getDirectHost(String stage) {
        return DirectTestRunProperties.getInstance().resolveDirectStageTypeToHost(stage);
    }
}

