package ru.yandex.autotests.direct.handles.service.utils.converters;

import ch.lambdaj.function.convert.Converter;
import ru.yandex.autotests.direct.handles.beans.MongoUserBean;
import ru.yandex.autotests.direct.utils.model.MongoUser;

/**
 * Created by mariabye on 03.06.2015.
 */
public class UserToMongoBeanConverter implements Converter<MongoUser,MongoUserBean> {
    @Override
    public MongoUserBean convert(MongoUser user) {
        if (user == null){
            return null;
        }
        MongoUserBean mongoUserBean = new MongoUserBean();
        mongoUserBean.setLogin(user.getLogin());
        mongoUserBean.setPassword(user.getPassword());
        mongoUserBean.setToken(user.getToken());
        mongoUserBean.setPaymentToken(user.getPaymentToken());
        mongoUserBean.setFinanceToken(user.getFinanceToken());
        mongoUserBean.setSandboxToken(user.getSandboxToken());
        mongoUserBean.setExpectedShard(user.getExpectedShard());
        return mongoUserBean;
    }
}
