package ru.yandex.autotests.direct.handles.service.utils.mongo;

import java.util.List;

import ch.lambdaj.Lambda;

import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.irt.restheart.config.MongoDatabases.BEAN_TEMAPLATES;

public class AccountsMongoHelper extends BaseMongoHelper<User> {
    private static final String COLLECTION = "TestUsers";
    private static final String QUERY_TEMPLATE = "{\"mongoUser.login\":\"%s\"}";

    public AccountsMongoHelper() {
        super(User.class);
    }

    public User getUser(String login) {
        String query = String.format(QUERY_TEMPLATE, login);
        return getMongoBean(query);
    }

    public List<User> getUserBySandboxToken(String sandboxToken) {
        String query = String.format("{\"mongoUser.sandboxToken\":\"%s\"}", sandboxToken);
        return getMongoBeans(query);
    }

    public void deleteUser(String login) {
        String query = String.format(QUERY_TEMPLATE, login);
        deleteMongoBean(query);
    }

    public List<User> getAllUserBeans() {
        List<User> users = getMongoBeans("{}");
        users = Lambda.sort(users, on(User.class).getLogin());
        return users;
    }

    @Override
    public String getDb() {
        return BEAN_TEMAPLATES.getDbName();
    }

    @Override
    public String getUniqueFilter(User user) {
        return String.format(QUERY_TEMPLATE, user.getLogin());
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }
}

