package ru.yandex.autotests.direct.scriptrunner.service.bslogs;

import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.springframework.stereotype.Service;

import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;

@Service
public class BsLogsService {
    private static Gson gson = new GsonBuilder()
            .serializeNulls()
            .setPrettyPrinting()
            .create();

    public String getBsLogs(String betaHost, String date, String method, int shard, Long cid, String... uuid) {
        RunBsTransportScriptResponse runBsTransportScriptResponse = new RunBsTransportScriptResponse();
        runBsTransportScriptResponse.setShard(shard);
        runBsTransportScriptResponse.setDate(date);
        runBsTransportScriptResponse.setMethod(method);
        runBsTransportScriptResponse.setUuid(uuid);
        try {
            DarkSideSteps darkSideSteps = new DarkSideSteps(betaHost);
            Map response =
                    darkSideSteps.getTransportSteps().getRawBsLogs(runBsTransportScriptResponse, true);
            return gson.toJson(response);
        } catch (Exception e) {
            throw new RuntimeException("error while getting bs logs", e);
        }
    }
}
