package ru.yandex.autotests.direct.scriptrunner.service.clientdata;

import org.springframework.stereotype.Service;

import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunResult;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunTask;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.TestScriptRunResponse;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

@Service
public class ClientDataService {

    public ScriptRunResult runBsClientData(ScriptRunTask task) {
        try {
            Integer shard = Integer.valueOf(task.getScriptRunParams().getScriptParams().get("--shard-id").toString());
            Integer cid = Integer.valueOf(task.getScriptRunParams().getScriptParams().get("--cid").toString());
            String parId = String.valueOf(task.getScriptRunParams().getScriptParams().get("--par-id"));
            Boolean isOnce = Boolean.valueOf(task.getScriptRunParams().getScriptParams().get("--once").toString());
            Boolean isFakeBs = Boolean.valueOf(task.getScriptRunParams().getScriptParams().get("--fake-bs").toString());
            Boolean isNoAutoBuggy =
                    Boolean.valueOf(task.getScriptRunParams().getScriptParams().get("--no-auto-buggy").toString());

            DarkSideSteps darkSideSteps = new DarkSideSteps(task.getScriptRunParams().getHost());
            ClientDataParams params =
                    new ClientDataParams()
                            .withShardId(shard)
                            .withCid(cid)
                            .withParId(parId)
                            .withOnce(isOnce)
                            .withFakeBs(isFakeBs)
                            .withNoAutoBuggy(isNoAutoBuggy);
            RunBsTransportScriptResponse scrResp = darkSideSteps.getTransportSteps().runBsClientDataScript(params);
            TestScriptRunResponse resp = new TestScriptRunResponse(0, "["+  JsonUtils.toString(scrResp, true) + "]", "");
            return new ScriptRunResult(task.getScriptRunParams().getHost(),
                    task.getScriptRunParams().getScriptParams().toString(), resp);
        } catch (Exception e) {
            throw new RuntimeException("error while running bsClientData.pl", e);
        }
    }
}
