package ru.yandex.autotests.direct.scriptrunner.service.exportmaster;

import org.springframework.stereotype.Service;

import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunResult;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunTask;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;

@Service
public class ExportMasterService {
    public ScriptRunResult runBsExportMaster(ScriptRunTask task) {
        try {
            Integer shard = Integer.valueOf(task.getScriptRunParams().getScriptParams().get("--shard-id").toString());
            Long cid = Long.valueOf(task.getScriptRunParams().getScriptParams().get("--cid").toString());
            DarkSideSteps darkSideSteps = new DarkSideSteps(task.getScriptRunParams().getHost());
            darkSideSteps.getTransportSteps().runBsExportMasterScript(shard, cid);
            return new ScriptRunResult(task.getScriptRunParams().getHost(),
                    task.getScriptRunParams().getScriptParams().toString(), "");
        } catch (Exception e) {
            Exception sse = new RuntimeException("error while running bsExportMaster.pl", e);
            return new ScriptRunResult(null, null, sse.toString());
        }
    }
}
