package ru.yandex.autotests.direct.scriptrunner.service.utils;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.http.client.utils.URIBuilder;

public class Environments {

    private static final String ENV_TC = "test-direct.yandex.ru";
    private static final String ENV_TC2 = "test2-direct.yandex.ru";

    private static final String ENV_TC_INTAPI = "intapi.test.direct.yandex.ru";
    private static final String ENV_BETA_INTAPI = "intapi.direct.yandex.ru";

    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";

    private static final int TC_HTTP_PORT = 9000;
    private static final int TC_HTTPS_PORT = 9443;

    private static final String JSON_RPC_PATH = "/jsonrpc";
    private static final String DIRECT_CONFIG_PATH = "/DirectConfiguration";

    public static URI getBsExportServiceUrl(String hostName) {
//        8141.ipv6-beta1.direct.yandex.ru => https://8141.beta1.intapi.direct.yandex.ru
//        ipv6.test-direct.yandex.ru => https:///intapi.test.direct.yandex.ru:9443

        try {
//            String intApiHostName = getIntApiHostName(hostName);
            URIBuilder builder = new URIBuilder()
                    .setScheme(SCHEME_HTTPS)
                    .setHost(hostName);
            if (hostName.contains(ENV_TC)) {
                builder.setPort(TC_HTTPS_PORT);
            }
            return builder.build();
        } catch (URISyntaxException e) {
            throw new IllegalStateException("Can not build BsExport service url for hostname " + hostName, e);
        }
    }

    public static URI getJsonRpcServiceUrl(String hostName) {
        return getServiceUrl(hostName, JSON_RPC_PATH);
    }

    public static URI getDirectConfigurationUrl(String hostName) {
        return getServiceUrl(hostName, DIRECT_CONFIG_PATH);
    }

    private static URI getServiceUrl(String hostName, String servicePath) {
        try {
            URIBuilder builder = new URIBuilder()
                    .setScheme(SCHEME_HTTP)
                    .setHost(hostName)
                    .setPath(servicePath);

            if (hostName.contains(ENV_TC) || hostName.contains(ENV_TC2)) {
                builder.setPort(TC_HTTP_PORT);
            }

            return builder.build();
        } catch (URISyntaxException e) {
            throw new IllegalStateException("Can not build " + servicePath.replaceAll("/", "")
                    + " service url for hostname " + hostName, e);
        }
    }

    private static String getIntApiHostName(String hostName) {
        String intApiHostName;
        if (hostName.contains(ENV_TC)) {
            // Запущено на ТС
            intApiHostName = ENV_TC_INTAPI + ":" + TC_HTTPS_PORT;
        } else {
            // Запущено на бете
            String betaPort = hostName.split("\\.")[0];
            String betaPpcdev = hostName.split("\\.")[1].split("-")[1];
            intApiHostName = betaPort + "." + betaPpcdev + "." + ENV_BETA_INTAPI;
        }
        return intApiHostName;
    }
}
